function data = safaData( options )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% PURPOSE: Load the data set.  Each data set has its own specific inputs.  
% 
% For example, the SOYS data set requires 3 inputs: 
% - Analyte string, 
% - Percentage of samples to allocate from spectrometer #1 (primary)
% - The remaining samples will come from spectrometer #2 (secocndary) 
%   and the third input specifies the 4-bucket percentages of these
%   samples.  For example, [10 10 50 30] indicates the percentages
%   associated with CALS1, CALS2, UNKS and VALS sample sets.
% In the case of the GOAT data set, there is only one input (because
% there is only one analyte and there is a distinct and separate 
% primary set of samples; only the percentages of how the secondary 
% set will be divided are specified).
%
% One can add their own data set, but the output struct ("data") must 
% minimally contain the following fields.  (Below is the output of 
% >> data = safaData(options) 
% where options.dataname = 'GOAT' and options.secPercent = [10 10 50 30].)
% >> disp(data)
%          Xp: [61x1050 double]
%          Xs: [48x1050 double]
%          Yp: [61x1 double]
%          Ys: [48x1 double]
%          Yc: [48x1 double]
%        calp: [1x61 double]
%       cals1: [6x1 double]
%       cals2: [6x1 double]
%        unks: [24x1 double]
%        vals: [12x1 double]
%        size: [61 6 6 24 12]
%        wave: [1x1050 double]
%      domain: {'1999'  '2002'}
%     analyte: 'JUNIPER'
%        name: 'GOAT'
%    distinct: 1
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
switch options.dataset
    
    case 'SOYS'
        data = safaSOYS( options.analyte, ...
                         options.priPercent, ...
                         options.secPercent );      
   
    case 'GOAT'
        data = safaGOAT( options.secPercent );  
 
% See readme.txt         
%     case 'CORN_A'
%         data = safaCORN( options.analyte, ...
%                          options.priPercent, ...
%                          options.secPercent, ...
%                          true );  
%     case 'CORN_B'
%         data = safaCORN( options.analyte, ...
%                          options.priPercent, ...
%                          options.secPercent, ...
%                          false );                              
        
end   
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end