function  output = safaDemo( CaseNum, nsplit ) 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
% PURPOSE: 
% - Extract algorithm options 
% - Extract data
% - Perform calibration updating
% - Archive results
%
%--------------------------------------------------------------------------
%
% USAGE: 
% >> output =  safaCase( CaseNum ) 
% where CaseNum is either 1 or 2.  
% - CaseNum = 1 performs calibration updating on SOY SEED (SOYS).  
% - CaseNum = 2 performs calibration updating on the GOAT data set.
% Here the default number of splits (nsplit) is set to 10 (for quick 
% gratification).
% 
% Alternatively, you can set the number of data splits to whatever you
% want, e.g., 100, 200, ...
% 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


%% SELECT DATASET AND ANALYTE
%--------------------------------------------------------------------------
%
switch CaseNum
    case 1
        dataset = 'SOYS';
        analyte = 'OIL';
        
    case 2
        dataset = 'GOAT';
        analyte = [];           % Automatically set to 'JUNIPER'
        
% See readme.txt        
%     case 3
%         dataset = 'CORN_A';
%         analyte = 'OIL';
%     case 4
%         dataset = 'CORN_B';
%         analyte = 'OIL';

end


%% GET OPTIONS
%--------------------------------------------------------------------------
%
options = safaOptions( dataset, analyte );  
if nargin < 2
    options.nsplit = 10;
else
    options.nsplit = nsplit; 
end    


%% GET DATA
%--------------------------------------------------------------------------
%
data = safaData( options );


%% PERFORM CALIBRATION UPDATING (the workhorse routine)
%--------------------------------------------------------------------------
%
results = safaUpdate( data, options );


%% ARCHIVE RESULTS
%--------------------------------------------------------------------------
%
output = struct('options',{options},'data',{data},'results',{results});



%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end