function data = safaGOAT( secPercent )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%% LOAD THE GOAT FECAL SOECTRA DATA SET
%--------------------------------------------------------------------------
% Load the variables R1 and R2 (the spectra from both spectrometers)
% and the reference measurements C where C(:,1), C(:,2) and C(:,3) 
% corresponds to moisture, protein and oil analytes.
load goat;
pri     = find(poop.year == 1999);
sec     = find(poop.year == 2002);
data.Xp = poop.X(pri,:);
data.Xs = poop.X(sec,:);
data.Yp = poop.y(pri);
data.Ys = poop.y(sec);
num.pri = length(pri);
num.sec = length(sec);


%% QUANTIZE SECONDARY REFERENCE VALUES INTO LOW, MEDIUM AND HIGH VALUES
%--------------------------------------------------------------------------
% This will be used shuffling purposes.
%
data.Yc = QuantizeRef(data.Ys,3); 


%% SPLIT SECONDARY SAMPLES INTO BINS
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
idxS       = GroupBins(data.Ys, secPercent);
data.calp  = 1:num.pri;
data.cals1 = idxS{1}; 
data.cals2 = idxS{2};
data.unks  = idxS{3}; 
data.vals  = idxS{4}; 
data.size  = [num.pri, length(data.cals1), length(data.cals2), ...
                       length(data.unks),  length(data.vals)];
          

%% ERRATA          
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
data.wave     = poop.wave;
data.domain   = {'1999','2002'};
data.analyte  = 'JUNIPER';
data.name     = 'GOAT';
data.distinct = true;

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

