function mat = safaMatrix( data, update )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% PURPOSE: Based upon the updating method, create the coefficient 
% matrices/vectors required for calibration and validation. 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


%% SAMPLE BLOCK INDICES
%--------------------------------------------------------------------------
calp  = data.calp(:)';
cals1 = data.cals1(:)';
cals2 = data.cals2(:)';
unks  = data.unks(:)';
vals  = data.vals(:)';


%% INITIALIZE MAT STRUCT
%--------------------------------------------------------------------------
mat = struct('Xp',   {[]},...
             'Yp',   {[]},...
             'Xs',   {[]},...
             'Ys',   {[]},...
             'R',    {[]},...
             'Xsval',{ data.Xs(vals,:) },...
             'Ysval',{ data.Ys(vals,:) });
 
         

%% COEFFICIENT MATRICES FOR CALIBRATION DATA 
%--------------------------------------------------------------------------
switch upper( update )
    
    case 'PPS'
        %---------------------------------------------------
        % Primary Predicting Secondary
        % Ensure sufficient number of labeled primary samples 
        if ~data.distinct
            samples = [calp cals1 cals2 unks];
            mat.Xp  = data.Xp(samples,:);
            mat.Yp  = data.Yp(samples,:);
        else    
            mat.Xp  = data.Xp;
            mat.Yp  = data.Yp;
        end  
        
    case 'SPS'   
        %---------------------------------------------------
        % Secondary Predicting Secondary
        % Ensure sufficient number of labeled secondary samples 
        if ~data.distinct
            samples = [calp cals1 cals2 unks];
        else    
            samples = [cals1 cals2 unks];
        end 
        mat.Xs = data.Xs(samples,:);
        mat.Ys = data.Ys(samples,:);
        
    case 'SSPS'   
        %---------------------------------------------------
        % Small Secondary Predicting Secondary
        samples = cals1;    
        mat.Xs  = data.Xs(samples,:);
        mat.Ys  = data.Ys(samples,:);
        
    case {'LMC','FA-1','FA-2'}
        %---------------------------------------------------
        % Primary samples
        samples = calp;
        mat.Xp  = data.Xp(samples,:);
        mat.Yp  = data.Yp(samples,:);
        % Secondary samples
        samples = cals1;
        mat.Xs  = data.Xs(samples,:);
        mat.Ys  = data.Ys(samples,:);
        
    case {'NARP','NARS','NARE','NARD'}
        % Primary samples
        samples = calp;
        mat.Xp  = data.Xp(samples,:);
        mat.Yp  = data.Yp(samples,:);
        % Residual samples
        Xsu = data.Xs(data.unks,:); 
        mat.R = hfResidual( mat.Xp, Xsu, update ); 
        
end    

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end



%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
%
%  [H] E L P E R    [F] U N C T I O N S 
%
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>



function R = hfResidual( Xp, Xsu, update )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   
switch lower(update)
    case {'narp'}, Vsu = hfLoadings(Xsu); 
                   R = Xp - (Xp*Vsu)*Vsu'; 
    case {'nars'}, Vp = hfLoadings(Xp);
                   R = Xsu - (Xsu*Vp)*Vp';
    case {'nare'}, R = mean(Xp) - mean(Xsu);
    case {'nard'}, R = diag(abs( mean(Xp) - mean(Xsu) ));
end   
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end



function V = hfLoadings( X )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
[~,~,V] = svd(X,'econ');
r = min(size(X)) - 1;
V = V(:,1:r); 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end












