function options = safaOptions(dataset,analyte,varargin)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
% INPUT:
% [1] dataset: 'GOAT' or 'SOYS'
% [2] analyte: For GOAT, the analyte will be set to 'juniper'.  For SOYS,
%     the options will be 'moisture', 'oil' or 'protein'
% [3] varargin: Inputs after dataset and analyte.  For example:
%     >> options = safaOptions('SOYS','oil','latent',1:25)
%
%--------------------------------------------------------------------------
%
% OUTPUT:
% [1] options struct required by safaMain.m  For example, the command 
%
%     >> options = safaOptions('SOYS','oil','latent',2:2:30,'ntau',30)
%
%     generates the following
%
%     >> disp(options)
%         nsplit: 300
%           seed: [1x300 double]
%         update: {9x1 cell}
%        regress: 'pls'
%        nlambda: 50
%           ntau: 30
%         latent: [2 4 6 8 10 12 14 16 18 20 22 24 26 28 30]
%     priPercent: 50
%     secPercent: [10 10 50 30]
%        dataset: 'GOAT'
%        analyte: 'JUNIPER'
%         domain: {'1999'  '2002'}
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


%% (A)  SET DEFAULT OPTIONS
%--------------------------------------------------------------------------
%
% NUMBER OF DATA SPLITS
%
options.nsplit = 300;
%
% RANDON SEEDS FOR SPLITS
%
options.seed = 1:options.nsplit; 
options.seed(1) = nan;
%
% CALIBRATION UPDATING METHODS
%
options.update = {'pps','sps','ssps','lmc','fa-1','fa-2',...                
                  'narp','nars','nare'}; 
options.update = options.update(:);          
%
% REGRESSION METHOD
%
options.regress = 'pls';
%
% NUMBER OF LAMBDA VALUES
%
options.nlambda = 50;
%
% NUMBER OF TAU VALUES
%
options.ntau = 50;
%
% NUMBER OF LATENT VECTORS
%
options.latent = 1:30;
%
% PERCENTAGE IN SAMPLES IN CALS1a, CALS1b, UNKS, and VALS BINS/BUCKETS
%
options.priPercent = 50;            % Applicable to SOYS
options.secPercent = [10 10 50 30]; 



%% (B)  OVERRIDE WITH USER-SUPPLIED INPUTS
%--------------------------------------------------------------------------
%
if ( nargin < 2 ), analyte = []; end
n = length(varargin);
p = n/2;
if rem(n,2)
    error('Wrong number of inputs for varargin.') 
end    
for i = 1:p
    f = varargin{2*i-1};
    v = varargin{2*i};
    options.(f) = v;
end  



%% (C)  DATA SET SPECIFIC OPTIONS
%--------------------------------------------------------------------------
%
options.dataset = upper(dataset);
if strcmpi(options.dataset,'GOAT')
    analyte = 'JUNIPER';
end 
options.analyte = upper(analyte); 
options.nupdate =  length(options.update);

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

