function lambda = safaPenalty(X,n,penlim)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% Get the lambda penalty parameters to be used in the augmented methods 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if ( nargin < 3 ), penlim = []; end
% If not supplied, use default lower and upper lambda limits 
if isempty(penlim)
    % Get the sum of singular values (without calling the SVD routine)
    s   = sum(sum(X.*X)); 
    % Approximates the largest singular value (slightly over-estimates)
    s   = sqrt(s);
    % Get maximum and minimum lambda values 
    Max = 100*s;
    Min = s/10000;
    penlim = [Min Max];
end
lambda = PenaltySample(n,penlim(1),penlim(2));
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

function lambda = PenaltySample(n,a,b)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% PURPOSE: Sample n lambda values, in an exponentially decaying fashion,
% in the interval [a,b] and then sort in descending order.
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
switch n
    case 1, lambda = a;
    case 2, lambda = [b;a];
    case 3, lambda = [b;a;0];    
    otherwise
        lambda = zeros(n,1);
        lowerbound = n*16*eps;
        lambda(n) = max(a,lowerbound);
        ratio = ( b/lambda(n) )^( 1/(n-1) );
        for i = (n-1):-1:1
            lambda(i)= ratio * lambda(i+1);
        end 
end
lambda = sort(lambda(:),'descend');
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end