function safaPlots( output )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

QuartilePlots( output.results, output.options.update )

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end



%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
%
%  [H] E L P E R    [F] U N C T I O N S 
%
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>



function QuartilePlots( results, update )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

num.update = length(update);
Qrmsev = cell(num.update,1);
Qr2 = Qrmsev;
P = [0 25 50];
num.percentile = length(P);
for k = 1:num.update
    r1 = results(k).rmse;
    r2 = results(k).r2;
    [num.split,num.model] = size(r1);
    x = nan(num.split,3);
    y = x;
    for i = 1:num.split
        z = r1(i,:);
        for j = 1:num.percentile
            % Get RMSEV at specified percentile
            x(i,j) = prctile(z,P(j));
            % Get corresponding R^2 value with just acquired RMSEV
            [~,idx] = min(abs(z - x(i,j)));
            y(i,j) = r2(i,idx);  
        end       
    end
    Qrmsev{k} = x';
    Qr2{k} = y';
end
Qrmsev = cell2mat(Qrmsev)';
Qr2 = cell2mat(Qr2)';


%% RMSEV PLOT BOXPLOTS
%--------------------------------------------------------------------------
figure('position',[100 100 1000 500],'color',[1 1 1]);
axes('position',[.1 .1 .8 .8]);
% Boxplots via yab.m
options = yabOptions;
options.newfigure = false;
[~,h] = yab(Qrmsev,[],options);
% Colors the boxes associated with each updating method with 
% a different color
G = kron(1:num.update,ones(1,num.percentile));
boxcolors = hsv(num.update);
% Get handles for IQR box colors
box = h.handle.box;
try
    hfill = cell2mat( {box.iqrfill}' );
catch 
    nbox = length(box);
    hfill = nan(nbox,1);
    for i = 1:nbox
         hfill(i) = box(i).iqrfill;
    end    
end    
for i = 1:num.update
    index = ( G==i );
    set(hfill(index),'facecolor',boxcolors(i,:));
end
% White vertical lines 
xcoord = num.percentile:num.percentile:(num.update-1)*num.percentile;
xcoord = repmat(xcoord + 0.5,2,1);
ylim = get(gca,'ylim');
ycoord = repmat(ylim(:),1,num.update-1);
hline = line(xcoord,ycoord);
set(hline,'linewidth',2,'color',[1 1 1]);
% Create the x-axis labels
set(gca,'xticklabel',[]);
a = num.percentile/2 + 0.5;
xtext = a : num.percentile : num.percentile*num.update;
ytext = ( ylim(1) - 0.03*diff(ylim) )*ones(1,num.update);
strtext = upper(update);
htext = text(xtext,ytext,strtext,'horizontalalignment','center');
set(htext,'fontsize',14,'fontweight','bold');
% Y-axis labels
ylabel('RMSEV','fontsize',17,'fontweight','bold');

%% R^2 PLOT BOXPLOTS
%--------------------------------------------------------------------------
figure('position',[100 100 1000 500],'color',[1 1 1]);
axes('position',[.1 .1 .8 .8]);
% Boxplots via yab.m
[~,h] = yab(Qr2,[],options);
% Colors the boxes associated with each updating method with 
% a different color
box = h.handle.box;
try
    hfill = cell2mat( {box.iqrfill}' );
catch 
    nbox = length(box);
    hfill = nan(nbox,1);
    for i = 1:nbox
         hfill(i) = box(i).iqrfill;
    end    
end 
for i = 1:num.update
    index = ( G==i );
    set(hfill(index),'facecolor',boxcolors(i,:));
end
% White vertical lines 
ylim = get(gca,'ylim');
ycoord = repmat(ylim(:),1,num.update-1);
hline = line(xcoord,ycoord);
set(hline,'linewidth',2,'color',[1 1 1]);
% Create the x-axis labels
set(gca,'xticklabel',[]);
ytext = ( ylim(1) - 0.03*diff(ylim) )*ones(1,num.update);
htext = text(xtext,ytext,strtext,'horizontalalignment','center');
set(htext,'fontsize',14,'fontweight','bold');
% Y-axis labels
ylabel('R^2','fontsize',17,'fontweight','bold');

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end


