function data = safaSOYS( analyte, priPercent, secPercent )
%% LOAD SOY SEED DATA SET
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


%% LOAD THE SOY SEED DATA SET
%--------------------------------------------------------------------------
% Load the variables R1 and R2 (the spectra from both spectrometers)
% and the reference measurements C where C(:,1), C(:,2) and C(:,3) 
% corresponds to moisture, protein and oil analytes.
%
R1 = []; R2 = []; C = []; 
load soys; 
AnalyteIdx = strcmpi({'MOISTURE','PROTEIN','OIL'},analyte);
data.Xp = R1;
data.Xs = R2;
data.Yp = C(:,AnalyteIdx);
data.Ys = data.Yp;


%% QUANTIZE REFERENCE VALUES INTO LOW, MEDIUM AND HIGH CLASS VALUES
%--------------------------------------------------------------------------
% This will be used shuffling purposes.
%
data.Yc = QuantizeRef(data.Yp,3); 


%% ASSIGN DEFAULT SPLIT OF SAMPLES INTO PRIMARY AND SECONDARY
%--------------------------------------------------------------------------
num.total = length(data.Yp);
num.pri   = round(priPercent/100*num.total);
num.sec   = num.total - num.pri;
calp      = 1:num.pri; calp = calp(:);
cals      = num.pri + (1:num.sec); cals = cals(:);
S         = PercentBins(secPercent,num.sec);


%% ASSIGN SAMPLE BLOCK INDICES
%--------------------------------------------------------------------------
data.calp  = calp;
data.cals1 = cals(S.idx{1});
data.cals2 = cals(S.idx{2});
data.unks  = cals(S.idx{3}); 
data.vals  = cals(S.idx{4});  
data.size  = [num.pri S.num(:)']; 


%% ERRATA
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
data.wave     = 1102:4:2498;         % Wavelengths
data.domain   = [1 2];               % Spectrometers/instruments
data.analyte  = upper(analyte);      % Analyte
data.name     = 'SOYS';              % 4-letter data set name
data.distinct = false;               % distinct or not (see safaCorn.m
                                     % for description)

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

