function data = safaShuffle( data, seed )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% PURPOSE: Shuffle the sample indicies.  The shuffling protocol differs if 
% a data set has samples that are the same across primary and secondary 
% conditions (e.g., SOYS), or if the primary and secondary samples are
% distinct.  In effect, the shuffling protocol is data set dependent.
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%% USE DEFAULT SPLIT 
%--------------------------------------------------------------------------
if isnan(seed)
    return;
end    

%% SHUFFLE INDICES
%--------------------------------------------------------------------------
num.pri = data.size(1);
num.sec = sum(data.size(2:end));
secPercent = data.size(2:end)/num.sec*100;
if ~data.distinct
    
    % Create shuffled indices associated with primary samples and
    % secondary samples across the CALS, UNKS and VALS sets.
    S = PercentBins(secPercent,num.sec);
    N = [num.pri(:); S.num(:)];
    percent = N/sum(N)*100;
    % GroupBins.m does the actual shuffling.  It tries to maintain the
    % same proportion of low, median and high reference measurements
    % values in each bin.
    idx = GroupBins(data.Yc,percent,seed);
    data.calp  = idx{1};
    data.cals1 = idx{2};
    data.cals2 = idx{3};
    data.unks  = idx{4};
    data.vals  = idx{5};
        
else
    % Note: GOAT has integer/discrete-valued reference measurements.  
    % Ensure each bin has roughly the same proportion of discrete 
    % reference measurements in each secondary bin.  
    if strcmpi(data.name,'GOAT')
        G = data.Ys;
    else
        G = data.Yc; 
    end    
    idxS = GroupBins( G, secPercent, seed );
    data.cals1 = idxS{1};
    data.cals2 = idxS{2};
    data.unks  = idxS{3};
    data.vals  = idxS{4};
end       

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end




