function results = safaUpdate( data, options )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% Perform calibration updating 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


%% CYCLE THROUGH DATA SPLITS AND UPDATES
%--------------------------------------------------------------------------
res = [];
for i = 1:options.nsplit
    % Shuffle data
    shufdata = safaShuffle( data, options.seed(i) ); 
    % For each shuffled data split, cycle through each updating method
    val = [];
    for j = 1:options.nupdate
        fprintf('%s[%d]: %s\n',data.name,i,options.update{j});  
        tmp = hfUpdate( shufdata, options, options.update{j} );
        val = StructPush(val,tmp,2,options.nupdate,j);
    end  
    % Add the results ("val") associated with the current data split to 
    % the heap of results
    res = StructPush(res,val,1,options.nsplit,i);
    fprintf('\n');
end


%% COLLATE RESULTS
%--------------------------------------------------------------------------
results = [];
for j = 1:options.nupdate
    metrics = hfCollateMetrics( res(:,j) );
    results = StructPush(results,metrics,1,options.nupdate,j);
end    

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end



%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
%
%  [H] E L P E R    [F] U N C T I O N S 
%
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>



function val = hfUpdate( data, options, update )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% Get calibration updating model and predict on validate set 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%% CALIBRATION MODEL
%--------------------------------------------------------------------------
mat = safaMatrix( data, update );
options.lambda = safaPenalty( mat.Xp, options.nlambda ); 
model = safaModel( mat, options, update );

%% VALIDATE MODEL
%--------------------------------------------------------------------------
Xc = bsxfun( @minus, mat.Xsval, model.Xmean );
Yhat = bsxfun( @plus, Xc*model.w, model.Ymean ); 
val  = perfMetrics(mat.Ysval,Yhat);
% Append additional performance fields to val struct
if ismember(upper(update),{'PPS','SPS','SSPS'})
    val.lambda = 0;
else    
    val.lambda = options.lambda(:)';
end    
val.nlatent = model.N(:)';
val = rmfield(val,{'slope','int'});

%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end


function metrics = hfCollateMetrics( res )
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% Collate the relevant metrics of interest
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
metrics.rmse    = cell2mat( {res.rmse}'    );
metrics.r2      = cell2mat( {res.r2}'      );
metrics.lambda  = cell2mat( {res.lambda}'  );
metrics.nlatent = cell2mat( {res.nlatent}'  );
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end
