function B = GroupBins(G,percbin,seed)
%% Stratify group ids into bins of different size
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% [1] G:  (n x 1) vector of sample ids (contains nA unique ids) where n
%     is the number of samples
% [2] percbin: (nB x 1) vector of percentages. The sample ids in G will
%     into one of the nB buckets.  The number of samples in the ith 
%     is specified by percent(i).  Moreover, the ith bucket contains 
%     percent(i)/100*n samples such that the group proportions (as much 
%     as possible) associated with G are preserved.
% [3] seed: random seed
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%% Get the unique info on G
%--------------------------------------------------------------------------
vec = univec(G);
A   = vec.idx;
nnA = vec.c;
nA  = vec.n;


%% Determine how many samples are in the buckets B contain mixtures of A
%--------------------------------------------------------------------------
n   = length(G);
nnB = round( percbin/100*n ); 
nnB(end) = n - sum(nnB(1:end-1));
nB = length(nnB);
B  = cell(nB,1); 


%% Determine how many samples are in the buckets B contain mixtures of A
%--------------------------------------------------------------------------
nBmat = zeros(nB,nA);
for i = 1:nA
    c = round(percbin/100*nnA(i));
    c(end) = nnA(i) - sum(c(1:end-1));    
    nBmat(:,i) = c(:);
end


%% Split contents of A into B according to nBmat
%--------------------------------------------------------------------------
if ( nargin < 3 ), seed = nan; end   
if ~isnan(seed)
    try
        rng( seed );
    catch
        rand('twister',seed);
    end
end
for i = 1:nA
    for j = 1:nB
        ppA = length(A{i});
        if ~isnan(seed)
            v = randperm( ppA );
        else
            v = 1:ppA; 
        end    
        v = v(1:nBmat(j,i));  
        a = A{i}(v);
        A{i} = setxor(A{i},a);
        B{j} = [B{j} a(:)'];
    end
end
for j = 1:nB
    B{j} = sort( B{j}(:) );
end   
  
        
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

