function S = PercentBins(percent,n)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


%% k: number of bins
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
k = length(percent);


%% Number of samples in each bin
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
num = round(percent/100*n);
num(k) = n - sum(num(1:k-1));
 

%% Left index (start) and right index (stop) for each bin
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
stopidx  = cumsum(num);
startidx = [1 stopidx(1:k-1)+1];


%% Indices and group id for each bin
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
idx = cell(k,1);
g = zeros(n,1);
for i = 1:k
    v = startidx(i):stopidx(i);
    idx{i} = v(:); 
    g(v) = i;
end


%% Archive
%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
S = struct('idx',{idx}, 'num',{num}, 'k',{k}, 'g', {g});
       
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end