function g = QuantizeRef(y,k)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% Quantize the vector y into k classes
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% Create a n-vector of [1,...,1,2,...,2,...,k,...k] where the 1s, 2s, ...,
% ks are roughly equal.
n = length(y);
v = sort( rem(0:(n-1),k)+1) ;
% Find the indices associated with the 1s, 2s, ..., ks.
vec = univec(v);
g = nan(size(y));
% Put the 1s, 2s, ..., ks into their appropriate place where the 1s
% correspond to the lowest values of y, the 2s correspond to the 2nd 
% lowest values of y, and so on (the ks correspond to the highest 
% values of y).
[~,sortidx] = sort(y);
for i = 1:vec.n
    g( sortidx(vec.idx{i}) ) = i; 
end 
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end