function S = StructPush(S,currentS,dim,n,i)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
% PURPOSE: Initialize a struct array S, and/or populate the ith 
% row/column of the struct array S with currentS.
%
% If dim=1 and i=1 then the struct array will be initialized to be of
% size (n x p) where p is the length of currentS.  In this case, the 
% struct S is initialized using n copies of currentS.  When 1 < i <= n, 
% the ith row of S is replaced with currentS, i.e., we push currentS onto 
% the ith row stack.
%
% If dim=2 and i=1 then the struct array will be initialized to be of 
% size (p x n) where p is the length of currentS.  In this case, the 
% struct S is initialized using n copies of currentS.  When 1 < i <= n, 
% the ith column of S is replaced with currentS, i.e., we push currentS
% onto the ith column stack.
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
if dim == 1
    
    if (i == 1)
        % Initialize S with n copies of currentS: size (n x p)
        S = repmat(currentS(:)',n,1);
    else
        % Replace ith row of S with currentS
        S(i,:) = currentS(:)';
    end
    
else
    
    if (i == 1)
        % Initialize S with n copies of currentS: size (p x n)
        S = repmat(currentS(:),1,n);
    else
        S(:,i) = currentS(:);
    end
    
end    
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

