function g = kron2(count,x)
%==========================================================================
% generalized version of matlab's kron.m
% g = kron2(count,x)
% INPUT
% > count: n-vector of counts
% > x: n-vector of elements (optional).  If optional, then x = 1:n. 
% OUTPUT
% > g: p-vector where p=sum(count)
%   >> Elements   1,...,  count(1) are  x(1)
%   >> Elements a+1,...,a+count(2) are  x(2) 
%      where a = count(1)
%   >> Elements a+1,...,a+count(3) are  x(3) 
%      where a = cumsum( count(1:2) )
%   >> ...
%   >> Elements a+1,...a+count(n) are x(n)       
%      where a = cumsum( count(1:n-1) )
%==========================================================================
count = count(:);
n = length(count);
if (nargin < 2), x = 1:n; end
x = x(:);
if ( length(x) ~= n ), error('x must be same length of nx'); end
a = [ 0; cumsum(count) ];
p = a(end);
g = nan(p,1);
for i = 1:n
    rows = ( a(i)+1 ) : a(i+1); 
    g(rows,:) = x(i);
end    
%==========================================================================
end