function vec = univec(x)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
if all( isnan(x) )
    nx = length(x);
    vec = struct('u',{NaN},'c',{nx},'n',{1},'idx',{{1:nx}});
    return
end    

%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
x = x(:);
finite   = isfinite(x);
nanele   = isnan(x);
notfinite = all([~finite ~nanele],2);

%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
v = x(finite);
[u,c] = countele(v);
n = length(u);
idx = cell(n,1);
curidx = find(finite);
for i = 1:n
    idx{i} = curidx( v == u(i) );
end    
if any(notfinite)
    v   = x(notfinite);
    neg = (v < 0);
    infidx = find(notfinite); 
    if any( neg )
        u = [u; -Inf];
        c = [c; sum(neg)];
        n = n + 1;
        idx = [idx; infidx(neg)];
    end
    if any( ~neg )
        u = [u; +Inf];
        c = [c; sum(~neg)];
        n = n + 1;
        idx = [idx; infidx(~neg)];
    end
end
if any(nanele)
    u = [u; NaN];
    c = [c; sum(nanele)];
    n = n + 1;
    idx = [idx; find(nanele)];
end

%--- --- --- --- --- --- --- --- --- --- --- --- --- --- ---
vec = struct('u',{u},'c',{c},'n',{n},'idx',{idx});
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end

function [element, count] = countele(x)
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
%
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
n       = length(x);
s       = sort( x(:) );
s       = [ s;  s(n)+1 ];
index   = find( diff(s) ~= 0 );
element = s(index);
count   = diff([0; index]);    
%>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
end