function opt=yabOptions
%==========================================================================

%
% String variable indicating how to compute the quartiles.  Choices 
% include: 'excluded', 'included', weighted' and 'matlab'.  See
% yabQuartiles.m below for details.
%
opt.method='matlab';          

%
% String variable indicating where to draw the whiskers.
% Choices are 'datum' and 'fence'.  The choice 'datum' uses the lowest 
% datum still within 1.5*IQR of the lower quartile, and the highest 
% datum still within 1.5*IQR of the upper quartile.  The choice 'fence' 
% uses the lower fence (Q1-1.5*IQR) and the upper fence (Q3+1.5*IQR).
%
opt.whisker='fence';            

%
% Color of the median line in the boxplot
%
opt.color.median=[0 0 0];       

%
% Fill color inisde the IQR box.
%
opt.color.iqrfill=[1 .6 0];      

%
% Boundary color of the IQR box
%
opt.color.iqrbox=[0 0 0];       

%
% Color of the lines outside IQR box (including the whiskers)
%
opt.color.outlines=[0 0 0];    

%
% Width of the lines in boxplot
%
opt.linewidth=1;                

%
% Width of the boxplot
%
opt.boxwidth=0.50;             

%
% Orient boxplot vertically if true, otherwise orient horizontally
%
opt.vertical=true;            

%
% Type of outlier marker
%
opt.marker.type='o';            

%
% Color on edge of outlier marker
%
opt.marker.edgecolor=[.6 1 .6]; 

%
% Color on inside of outlier marker (if applicable)
%
opt.marker.facecolor=[1 1 1];   

%
% Size of outlier marker
%
opt.marker.size=7;            

%
% If true, generate new figure when rendering boxplot, otherwise use
% existing axes (if axes are present).
%
opt.newfigure=true;

%
%
%
opt.clf=false;

%
%
%
opt.outlinestyle = '--';

%==========================================================================
end

