      Subroutine rskin
     &          (ht, time, curr, parms, j_max, dcurr, H, rvar)
c
c     Stygar Resistive Wall Model
c
c Author/Date: Rick Spielman 2017-01-02
c     Modifications:
c
c
c This routine calculates the average skin depth as a function of
c  time using the solution to the magnetic diffusion equation.
c This subroutine is based on many published solutions. A nice
c  description is found in:
c
c
c     we assume µ is set to µ0
c
c Define passed variables
c
      real ht, time, curr, parms(*), dcurr(*), H(*), rvar
      integer j_max
c
c Define internal variables
c
      integer itime

      real       pi
      parameter (pi=3.14159)
c
      real sigma, depth, cyl_len, cyl_rout, cyl_rin,
     &     disk_len, disk_rout, iold
      real deltai, H_ave, skin_depth

c
c Values in the parms array are placed into internal variables
c
      sigma     = parms(1)
      depth     = parms(2)
      cyl_len   = parms(3)
      cyl_rout  = parms(4)
      cyl_rin   = parms(5)
      disk_len  = parms(6)
      disk_rout = parms(7)

      iold      = parms(10)
c
c Define material µ
c
      zmu0 = 4 * pi * 1.0e-7
c
c redefine depth as the depth increment
c
      depth = depth / real(j_max-1)
c
c Calculate the delta I for this time step
c
      deltai = ( curr - iold )
c
c Calculate the time index
c
      itime = int( time / ht )
c
c Place the delta I in the correct location in the delta I vector
c
      dcurr(itime) = deltai
c
c Calculate H as a function of position for all values of deltai up to
c  itime, we do anew for every time step.
c First zero the array
c The array H is then filled up with the values of magnetic field for
c  each depth j for all past current impulses itime-1.
c
      do j = 1, j_max
        H(j) = 0.0
      end do

      do j = 1, j_max

        do i = 1, itime-1
          H(j) = H(j) + ( dcurr(i) / (2.0 * pi * cyl_rin )) *
     &           (1.0 - erf( (real(j-1) * depth / 2.0 ) *
     &           sqrt( sigma * zmu0 / ( time - real(i) * ht ) ) ) )
        enddo

      enddo

c      print '(11e10.3)', H(1), H(2), H(3), H(4), H(5), H(6),
c     &                   H(7), H(8), H(9), H(10), H(11)
c      print '(10e10.3)', H(12), H(13), H(14), H(15), H(16), H(17),
c     &                   H(18), H(19), H(20), H(21)

c
c Calculate average H
c
      H_ave = 0.0

      H_ave = 0.5 * H(1)

      do j = 2, j_max-1
        H_ave = H_ave + H(j)
      enddo

      H_ave = H_ave + 0.5 * H(j_max)

      H_ave = H_ave / real(j_max)

c      print '(A,1pE10.3)', ' H_ave= ', H_ave
c
c Calculate the skin depth where H = H_ave
c We assume that H monotonically decreases into the metal
c Don't count j=1 in the depth real(j-1) but add back one since we
c overshot the value by testing from the lowest to the highest.
c
      do j = j_max, 1, -1

       if (H(j) .ge. H_ave ) then
         exit
       endif

      enddo

      if ( H_ave .eq. 0 ) j = 2

      skin_depth = real(j) * depth

      print '(A,I4,A,1pE10.3)', 'j= ',j, ' skin depth= ', skin_depth
c
c Calculate the resistance
c Assume that the radius is >>>> skin_depth
c
c First calculate the coaxial terms
c
      if ( sigma .le. 1.0 ) sigma = 1.0

      if ( cyl_len .gt. 0.0 ) then
        rvar = ( 1.0 / sigma ) * cyl_len /
     &         ( pi * 2.0 * cyl_rin * skin_depth )
        rvar = rvar + ( ( 1.0 / sigma )  * cyl_len /
     &         ( pi * 2.0 * cyl_rout * skin_depth ) )
      endif
c
c Then calculate the disk terms
c
      if ( disk_len .gt. 0.0 ) then
        rvar = ( 1.0 / sigma ) * disk_len /
     &         ( pi * 2.0 * disk_rout * skin_depth )
        rvar = rvar * 2.0
      endif
c
c
c Place the present value of current into parms(10) for this element
c  to be passed back to model.f.
c
      parms(10) = curr

      return
      end
