      subroutine reset_mitl (index)
c
c ---------------------------------------------------------------------
c
c Resets the conductances in an MITL.
c This model uses circumference of feed and gap, where gap is assumed
c constant.
c
c ---------------------------------------------------------------------
c
c Modifications:
c KWS, 08/12/97, Changed 'esat' parameter, definitions of v1 and i2
c KWS, 03/02/94, Based on a simple LC network.  Checked physics, Looks OK.
c KWS, 05/30/95, Added loss current density to the anode for Zflow Plasma
c                loss model
c 2014-05-02 RBS: Changed integer*4 to integer
c 2014-05-07 RBS: All internal variables explicitly defined
c 2015-06-23 RBS: Removed unused variables edenomv1, gg, fixed a typo on
c                 the real declaration of zmuo (was zmu0)
c 2015-06-23 RBS: Initialized area to 0 to stop a compile warning
c                 Explicit real definition of area
c ---------------------------------------------------------------------
c
c Define passed variables
c
      integer  index
c
c Include files
c
      include 'zdemmax.h'
      include 'zdemcomm.h'
      include 'zdemwork.h'
c
c Define internal variables
c
      real pi, zmuo, epso, cspeed, esat, con1, bm, xy
c
      parameter (pi      = 3.1415927)
      parameter (zmuo    = 4.0e-7 * pi)
      parameter (epso    = 8.8541878e-12)
      parameter (cspeed  = 2.99792458e+8)
c      parameter (esat    = 4.0e+7)
      parameter (esat    = 6.0e+7)
      parameter (con1    = 0.0625 * zmuo * zmuo)
      parameter (bm      = 0.5)
      parameter (xy      = 0.9 * bm)
c
      real       circum, gap, tau, rcircum2, rgap, rgap2, eturnon
      real       elec_len, area, elec_area, e1, emp1, v1mv, a1,
     &           zir1, zir2, argp, con2, b1s, bc1s, rbc1s, arg1, g1x,
     &           fung1,xx, ftail, g1y, cup, cdn, anodeloss, alossden
c
c
c
      ibranch   = indexmitl(1,index)
      iblock    = indexmitl(2,index)
      node1     = indexmitl(3,index)
      node2     = indexmitl(4,index)
      circum    = pin(1,iblock,ibranch)
      gap       = pin(2,iblock,ibranch)
      tau       = pin(3,iblock,ibranch)
      rcircum2  = pin(6,iblock,ibranch)
      rgap      = pin(7,iblock,ibranch)
      rgap2     = pin(8,iblock,ibranch)
      eturnon   = pin(9,iblock,ibranch)
      area = 0.0
      
      elec_len  = tau * cspeed
      elec_area = elec_len * circum
      if (eturnon .lt. esat) then
         edenom  = 1.0 / (esat - eturnon)
      else
         edenom  =  1.0e-12
      endif
c
c Reset the conductances.
c
      do node = node1, node2
        area = elec_area
        v1    = 0.5 * abs (v(node,ibranch)+vold(node,ibranch))
        e1    = v1 * rgap
c
c
        if (e1 .ge. eturnon) then
          if (e1 .gt. esat) then
            emp1 = 1.0
          else
            emp1 = (e1-eturnon) * edenom
          end if
          v1mv = 0.00001 + 1.0e-6*v1
          if (v1mv .gt. 0.09855) then
            a1 = 1.38 * (v1mv+0.0001)**(-0.036)
          else
            a1 = 1.5
          end if
          zir1  = zir(node-1,ibranch) + zir(node,ibranch)
          zir2  = zirn(node-1,ibranch) + zirn(node,ibranch)
          zir1  = zir1 + zir2
          argp  = area * rgap2
          con2  = 1.113e-5 * rgap2
          b1s   = con1 * zir1 * zir1 * rcircum2 + 1.0e-6
          bc1s  = con2 * (1.022*v1mv + v1mv*v1mv + 0.0001)
c
c     ref:  R. V. Lovelace and E. Ott, Pys. Fluids, 17, 1263 (1974)
c           (Gaussian);
c           also, J. M. Creedon, J. Appl. Phys, 48, 1072 (1977) (MKS).
c
          rbc1s = 1.0 / bc1s
c
c     exp with no attenuated tail - nominal parameters
c
          arg1 = 1.21 * b1s * rbc1s
          g1x  = arg1**2.5
c
c     super exponential g model with attenuated tail
c
          if (g1x .gt. 40.0) then
            fung1 = 0.0
          else if (g1x .lt. -40.0) then
            fung1 = 2.35e17
          else
            fung1 = exp(-g1x)
          endif
          xx    = bm * (b1s * rbc1s)
          if (xx .gt. xy) then
              if ((xx-xy).gt. 4.0) then
                ftail = 0.0
              else
                ftail = exp(-10.0*(xx-xy))
              endif
          else
            ftail = 1.0
          end if
          fung1          = fung1 * ftail
          g1y            = 1.99e-3 * (v1mv**(a1-1.0)) * argp * fung1
         g(node,ibranch) = g1y * emp1
        else
          g(node,ibranch) = 0.0
        end if
c
      end do
c
c --- KWS  Zflow Plasma Loss Model ---
c
c     Calculate loss current density to the anode
c
      cup                    = zir(node1-1,ibranch)
      cdn                    = zir(node2,ibranch)
      anodeloss              = cup-cdn
      alossden               = anodeloss/(area*float(node2-node1+1))
      pin(10,iblock,ibranch) = alossden
c
c ------------------------------------
c
      return
      end
