      subroutine banner_start_run (bgin)
c
c-----Description-------------------------------------------------------
c
c Author/Date: Mathias Bavay  11/04
c      Modifications:
c
c 2008-07-16 RBS gFortran fix, remove Time, leave Date_and_time
c 2008-09-10 RBS redefine buffer to 80
c 2008-11-07 RBS Split off Banner_start from start_run.f
c 2008-11-07 RBS Write & include clean up
c 2012-04-11 RBS: Fixed bgin and start time issues
c 2015-12-28 RBS: Extended bgin to include hours for long runs
c ----------------------------------------------------------------------
c
c Purpose: This subroutine prints a banner at the begining of a run.
c     
c Called by: Program ZDEM
c
c Calls:  Subroutines DATE_AND_TIME
c
c Define passed variables
c
      real bgin
c
c Include files
c
      include 'version.h'
c
c Define internal variables
c
      character   buffer*80
      character   date*8
      character   time*10
      character   zone*5
      integer     values(8)
c
c ----------------------------------------------------------------------
c Write out current version number and date and time to the screen
c
      write (buffer,'(A,A,A)') ' *****  ',screamer_version,'  *****'
      call writebuffer(buffer)
c
c  Get the current date and time
c
      call date_and_time(date,time,zone,values)
c
      write (buffer,'(A,i2.2,A,i2.2,A,i2.2,A,i3.3,A)')
     & ' *****  The current time is: '
     & ,values(5),':',values(6),':',values(7),':',values(8), '  *****'
      call writebuffer(buffer)
      write (buffer,'(A,i2.2,A,i2.2,A,i4.4,A)')
     & ' *****  The current date is: ',
     & values(2),'/',values(3),'/',values(1),'  *****'
      call writebuffer(buffer)
      bgin = values(5)*3600 + values(6)*60 + values(7) + values(8)*1e-3
c     write(*,*) bgin

      return
      end