      subroutine main_loop

c
c-----Description-------------------------------------------------------
c
c Author/Date: Mathias Bavay  11/04
c      Modifications:
c 2014-11-03 YG: Split out solver routines and added new solver
c 2014-12-12 RBS: Changed the max array size in band matrix and
c                 solvermdgaussian to max_am
c 2015-03-25 RBS: The uses of the x vector were totally removed. x was a
c                 dummy variable that was populated with the RHS_band.
c                 The vector x was also removed from common in
c                 zdemwork.h.
c 2015-03-25 RBS: Vector a removed from common in zdemwork.h and placed
c                 explicitly here. Passed directly into screamermatrix.
c 2015-03-25 RBS: The matrix am_band and the vector rhs_band were moved
c                 from common in zdemwork.h and explicitly defined here.
c                 This is the only location those variables are used.
c 2015-06-17 RBS: Some comments added. No substantive changes.
c 2015-06-18 RBS: Moved iptold, iptime, jdiv, and nk from zdemloop.h
c 2015-06-23 RBS: Make calculation of iptime explicitly integer.
c 2015-06-23 RBS: Made calculation of vn and zirn explicitly real*4 in
c                 lines 145,146
c 2015-12-25 YG:  a, am_band, and rhs_band are defined in zdemwork.h.
C                 Also removed parameter a in the screamermatrix.
c 2016-03-16 RBS: Cleaned up the write formats.
c
c
c ----------------------------------------------------------------------
c
c Purpose: This subroutines performs the calculations. 
c     
c Called by: Program ZDEM
c    
c Include the files with the various keywords and integer flags.
c
      include 'zdemparm.h'
      include 'zdempprm.h'
c
c Include the files specifying the array dimensions and the common
c blocks.
c
      include 'zdemmax.h'
      include 'zdemcomm.h'
      include 'zdemwork.h'
      include 'zdemout.h'
      include 'zdemenv.h'
      include 'zdemvars.h'
      include 'zdemloop.h'

c
c Define internal variables
c

      integer iptold, iptime, jdiv, nk, nzz

c
c Include file with version string
c
      include 'version.h'
      
c
c Initialize
c iptime is recalculated each time step
c Is iptold used only for special case where tim = 0.0?
c
c      iptime = 0
c
c Print out time step to monitor run progress
c
      iptold=iptime
      if (tmax .le. 100.0e-6) then
        iptime = int(tim * 1.0e9)
        if (tmax .gt. 10.0e-6) then
          jdiv=2000
         else
          jdiv=200
         end if
        if ((mod(iptime,jdiv) .eq. 0) .and. (iptold .ne. iptime)) then
          write (6, '(A,i5,A)') ' Time = ', iptime,' ns'
         end if
       else if ((tmax .gt. 100.0e-6) .and. (tmax .le. 100.0e-3)) then
        iptime = int(tim * 1.0e6)
        if (tmax .gt. 10.0e-3) then
          jdiv=2000
         else
          jdiv=200
         end if
        if ((mod(iptime,jdiv).eq.0) .and. (iptold .ne. iptime)) then
          write (6, '(A,i5,A)') ' Time = ', iptime,' microsec'
         end if
        else
         iptime = int(tim * 1.0e3)
         if (tmax .gt. 10.0) then
           jdiv=2000
          else
           jdiv=200
          end if
         if ((mod(iptime,jdiv) .eq. 0) .and. (iptold .ne. iptime)) then
           write (6, '(A,i5,A)') ' Time = ', iptime,' ms'
          end if
         end if
C
C  The next subroutine calculates the coefficient matrix in the screamer
C  format.
C
        call screamermatrix

c
c The next subroutine converts the coefficient matrix in the screamer
c format to the full coefficent matrix and the right hand side of the
c linear system on each time step. The subroutine has the option to
c print out the matrix and the right hand side for diagnostics.
c
c nk is the size of the matrix A and is based on the total number of
c nodes in all of the branches. ntot is generated by counting up the
c nodes as they are read into the problem. It is the REAL size of the
c matrix.
c
c Max_nodes passed in common is the maximum size of the A matrix and b
c vector that is allowed. It is set in zdemmax.h.
c
c We define max_am in common as the passed maximum dimension of the
c am_band matrix and b vector
c
      nk = ntot*2

      call bandmatrix(a,am_band,rhs_band,nk,nr,
     &                indexb,nadd_array,nb,topbranch,max_am)

c
c The next subroutine solves the linear system using modified Gaussian
c elemination procedure based on the highly structured sparce matrix
c obtained on the previous step. The solution vector is in the rhs_band
c vector.
c
      call solvermdgauss(am_band,rhs_band,nk,max_am,nadd_array,nb,nr)
c
c  Prepare to find voltage and curent at each node.
c
      do ib = 1, nb
        nzz  = nadd_array(ib) * k
        nrx  = nr(ib)
        do i = 1, nrx
          j          = (i-1)*2 + 1 + nzz
          vn(i,ib)   = real(rhs_band(j))
          zirn(i,ib) = real(rhs_band(j+1))
          end do
        end do
c
      call energy_checks
c
c Fill the file-table-ufo-pff-csv-sfc arrays with the 
c appropriate numbers.
c
      if (numout .gt. 0) then
        call build_out (tim, timehalf, ht, rht)
        end if
c
c If we have reached a printing cycle (icycle = ncycle) then
c print out current status at the half time step.
c
      if (icycle .ge. ncycle) then
        icycle = 0
        call cycle_print (i2, tim-0.5*ht, esour, eind, ecap, econ,eres,
     &                    elossind, elosscap, error)
        end if
c
c Now put the new values of V and I into the old V and I arrays for the
c next iteration.
c
      do ib = 1, nb
        nrx = nr(ib)
        do i = 1, nrx
          vold(i,ib)   = v(i,ib)
          v(i,ib)      = vn(i,ib)
          zirold(i,ib) = zir(i,ib)
          zir(i,ib)    = zirn(i,ib)
          end do
        end do

      return
      end
