c
c ----------------------------------------------------------------------
c
c    SSSS    CCCC   RRRRR   EEEEEE    AA    M    M  EEEEEE  RRRRR
c   S    S  C    C  R    R  E        A  A   MM  MM  E       R    R
c   S       C       R    R  E       A    A  M MM M  E       R    R
c    SSSS   C       RRRRR   EEEEE   AAAAAA  M MM M  EEEEE   RRRRR
c        S  C       R   R   E       A    A  M    M  E       R   R
c   S    S  C    C  R    R  E       A    A  M    M  E       R    R
c    SSSS    CCCC   R    R  EEEEEE  A    A  M    M  EEEEEE  R    R
c
c ----------------------------------------------------------------------
c
c     Point of Contact:
c       Rick B. Spielman
c       Idaho State University
c       -- Idaho Accelerator Center
c       1500 Alvin Ricken Drive
c       Pocatello, ID  83201-2783
c       505-715-0416 (cell)
c       spierick@isu.edu (e-mail)
c
c     SCREAMER is open source under the GNU GPL 3.0 License
c
c ----------------------------------------------------------------------
c
c     series matrix load and solution
c
c     single line code for pulse power design
c     array parameters - nr mesh points - 1 at top
c     v,vn = old, new node voltage
c     zib = current entering branch segment
c     zir,zirn = old, new long. current in R - L segment
c     zlr = series inductance, c = shunt capacitance, 
c     g = shunt conductance, rr = series resistance
c     shunt capacitance at the half time step.
c     inductance (vacuum) = impedance/speed of light
c     capacitance (vacuum) = 1/(impedance*speed of light)
c     capacitance (vacuum) = epso*width*length/height
c     inductance (vacuum) = zmuo*height*length/width
c
c ----------------------------------------------------------------------
c Modifications:
c
c 2015-06-23 RBS: integer ibgin was removed as unused.
c 2018-08-09 RBS: removed all c++ links, added read filename
c ----------------------------------------------------------------------
c
c Include the files with the various keywords and integer flags.
c
      include 'zdemparm.h'
      include 'zdempprm.h'
c
c Include the files that specify the array dimensions
c and define the common blocks.
c
      include 'zdemmax.h'
      include 'zdemcomm.h'
      include 'zdemwork.h'
      include 'zdemout.h'
      include 'zdemenv.h'
      include 'zdemvars.h'
      include 'zdemloop.h'
c
c Define local variables
c
      character     ifile*80
      integer       clen
      integer       status

c---------------------------------------------------------
c INITIALIZATIONS
c
c Clear arrays
c
      call clrarry

c
c Read in the file name
c
      write(6,'(A$)') ' Enter run file name: '
      read (5,'(A)') ifile
      clen = len(ifile)

c
c print a start banner (date, time, version...)
c
      call banner_start_run(bgin)

c
c Get environment variables
c
      call get_env_var(ifile,clen)

c
c Read in the SCREAMER input file (assigned to logical unit 4)
c This subroutine also gives a "nice" print-out of the data.
c

      call readscreamerdata(status)
      if (status .ne. 0) then
        goto 802
      endif

c
c Echo the set-up showing all values (slightly cryptic, but useful
c for debugging).
c

      if (echoset .eq. yes_echo) then
        call echo_setup
      end if

c
c initialize the problem
c

      call init_problem(status)
      if (status .ne. 0) then
        call close_outfile(iunit,ierr)
        goto 802
      endif

c
c---------------------------------------------------------
c CALCULATIONS
c
c  First, put out a banner page for the status cycle printing for t > 0.
c
      call banner (cyclln)
c
c ***** Loop over all time steps. *****
c   tim is the problem time and timehalf is the current half-step time.
c   icycle is a counter for printout of current circuit status.
c

      do 2 i2 = 1, nsteps
        tim        = i2 * ht
        timehalf   = tim - htd2
        icycle     = icycle + 1
        call main_loop
    2 continue      

c---------------------------------------------------------
c OUTPUTS and END
c

      call close_outfile(iunit,ierr)

c
c ***** Now do the output requests if we executed all cycles.
c

       call write_outs
  802  continue
       call banner_end_run(ifile,clen,bgin)

      stop
      end
