      subroutine sfcvals
c
c-------Description-----------------------------------------------------
c
c  Source File : sfcvals.f
c
c  Author      : Mark Kiefer
c                  
c  Purpose     : Creates file which contains the points for the SFC
c                requests.
c
c  Modifications:
c    1/6/98, MLK: Original version
c 2015-06-23 RBS: Placed newfile, oldfile, fflag declarations internal
c                 removed them from zdemout to get rid of compiler
c                 warnings.
c 2015-06-23 RBS: Declared time_flag, half_step, whole_step internal to
c                 function to eliminate compiler warnings
c 2015-03-30 RBS: iday,imon,iyr removed from integer definition - unused
c                 explicit integer conversion line 103
c 2015-06-23 RBS: no_text explicitly declared integer - initialized to 0
c
c  The format of this file is:
c  TITREG=screamer-title-line
c    (unlimited no. of characters)
c  DATHEU=date
c    (10 characters: xx/yy/zz, e.g., 08/10/96)
c  TYPEDO=REEL
c  NBCOLO=number-of-data-columns
c    (=number of SFC requests + 1)
c  NBLIGN=number-of-data-points
c    (=nptssfc)
c  TITCOL=label-for-each-column-of-data
c    (max of 15 characters per label, such as "Load Current")
c    (This is the user-entered label or generated by SCREAMER)
c  LABCOL=generic-labels-for-each-column-of-data
c    (max of 15 characters per label, such as "Voltage")
c  UNICOL=labels-for-units-of-measure-for-each-column
c    (max of 15 characters per label, such as VOLTS, SEC)
c  COMENT=version-of-SCREAMER-used
c  DONNEE=
c  time(1) data1(1) data2(1) .... dataN(1)
c  time(2) data1(2) data2(2) .... dataN(2)
c  ....
c  time(NBLIGN) data1(NBLIGN) data2(NBLIGN) .... dataN(NBLIGN)
c    (these lines contain the data, where N=NBCOLO-1)
c
c-------Include Files---------------------------------------------------
c
      include 'zdemparm.h'
      include 'zdempprm.h'
      include 'zdemmax.h'
      include 'zdemout.h'
      include 'zdemcomm.h'
      include 'zdemenv.h'
      include 'version.h'
c
c-------Input Parameters------------------------------------------------
c     NONE
c-------Output Parameters-----------------------------------------------
c     NONE
c-------Constants-------------------------------------------------------
c
      integer    sfc_unit
      parameter (sfc_unit    =  24)

      integer   newfile, oldfile, fflag
      parameter (newfile=1, oldfile=2)

      integer    no_text
      parameter (no_text     =   0)

c
c ***** Time flag parameters ******
c

      integer time_flag, half_step,     whole_step
      parameter         (half_step = 1, whole_step = 2)

c
c-------Local Variables-------------------------------------------------
c
      character  sfcfile*80
      integer    i, ip, j, i1, i2
      integer    date_time(8)
      character*10 dt_return(3)
c
c-------Labels----------------------------------------------------------
c
      include 'sfc.h'
c
c-------Subroutine Body-------------------------------------------------
c
c Clear the output buffers, calculate the record size of the output
c   parameter file, and "gather" all of the SFC output requests together.
c
      call clear_outbuf
      ibufsize = numout*2+2
      call gather (iouttype, osfc, maxout, indices, numsfc)
c
c Find start time and stop time, skip factor and nptssfc (these will
c    be the same for all SFC output requests
c
      tstart  = tbegout(indices(1))
      tstop   = tendout(indices(1))
      nskip   = ifsteps (maxfpts, ht, tstart, tstop)
      nptssfc = int(((tstop - tstart) / ht) / nskip) + 1
c
c  Create the SFC filename based on the input file name
c
      sfcfile = base_filename
      call strip (sfcfile, i_1st, i_last)
      iend = i_last - i_1st + 5
      sfcfile(1:iend) = sfcfile(i_1st:i_last)//'.sfc'
      open (unit=sfc_unit, file=sfcfile(1:iend), status='unknown')
c      
c  Process SFC output requests
c
      time_flag  = whole_step
      ncycle     = 0
      ipntcnt_wh = 0
      ipntcnt_hf = 0
      fflag      = oldfile
      iunit      = outunit
      call open_outfile (iunit, fflag, ierr)
c
c  Get the value at time 0.0
c
      newrec  = 1
      ipntcnt = 1
      call read_outfile (iunit, newrec, time_flag, indices(1), 
     +                   ibufsize, tmptime, tmpval, ierr)
      timeout(ipntcnt,1) = tmptime
      outdata(ipntcnt,1) = tmpval
      newrec = 0
      do i = 2, numsfc
         call read_outfile (iunit, newrec, time_flag, indices(i),
     +                      ibufsize, tmptime, tmpval, ierr)
         outdata(ipntcnt,i) = tmpval
      enddo
c
c Get values for the rest of the simulation
c
      newrec = 1
      call read_outfile (iunit, newrec, time_flag, indices(1),
     +                    ibufsize, tmptime, tmpval, ierr)
c
      do while (ierr .eq. 0)
         ncycle = ncycle + 1
         if (ncycle .ge. nskip) then
            ipntcnt = ipntcnt + 1
            timeout(ipntcnt,1) = tmptime
            outdata(ipntcnt,1) = tmpval
            newrec = 0
            do i = 2, numsfc
               call read_outfile(iunit, newrec, time_flag, indices(i),
     +                           ibufsize, tmptime, tmpval, ierr)
               outdata(ipntcnt,i) = tmpval
            enddo
            ncycle = 0
         endif
         newrec = 1
         call read_outfile (iunit, newrec, time_flag, indices(1), 
     +                      ibufsize, tmptime, tmpval, ierr)
      enddo
      call close_outfile (iunit,ierr)
c
c Set TITCOL strings to output request title, if it exists
c
      do j = 1, numsfc
        i = indices(j)
        ip = itypout(i)
        call strip (lblout(i), istart, iend)
        if (istart .eq. no_text) then
          lblout(i)(1:sfc_len) = sfc_titcol(ip)(1:sfc_len)
        end if
      end do
c
c Now write it all out.
c
      call strip (title, i1, i2)
      write (sfc_unit, 1010) title(i1:i2)
      call date_and_time (dt_return (1), dt_return (2),
     &               dt_return (3), date_time)
      write (sfc_unit, 1000) date_time(2), date_time(3), date_time(1)
      write (sfc_unit, 1012)
      write (sfc_unit, 1006) numsfc+1
      write (sfc_unit, 1007) nptssfc
      write (sfc_unit, 1001)
     & sfc_tlab, (lblout(indices(j)),j=1,numsfc)
      write (sfc_unit, 1002)
     & sfc_tlab, (sfc_labcol(itypout(indices(j))),j=1,numsfc)
      write (sfc_unit, 1003)
     & sfc_tuni, (sfc_unicol(itypout(indices(j))),j=1,numsfc)
      write (sfc_unit, 1011) screamer_version
      write (sfc_unit, 1013)
c
c Write out all values at each time step: first line has time and first 100
c   variables.
c
      do i = 1, nptssfc
c
c Set the number of points to be printed in the first line of the group
c of values.
c
        write (sfc_unit, 1009) timeout(i,1), (outdata(i,j), j=1,numsfc)
c
c
      end do        !end of loop over time points
c
c
c Now close the file
c
      close (unit=sfc_unit)
c
c-------FORMAT Statements-----------------------------------------------
c
 1010 format('TITREG=',a)
 1000 format('DATHEU=',i2.2,'/',i2.2,'/',i4.4)
 1012 format('TYPEDO=REEL')
 1006 format('NBCOLO=',i3)
 1007 format('NBLIGN=',i5)
 1001 format('TITCOL=',100(a15,';'))
 1002 format('LABCOL=',100(a15,';'))
 1003 format('UNICOL=',100(a15,';'))
 1011 format('COMENT=',a)
 1013 format('DONNEE=')
 1009 format(1pe13.6, 100(' ',1pe13.6))
c
c-------End of Subroutine-----------------------------------------------
c
      return
      end
